<?php


namespace Cms\Client\Command\Contract\Command;

use Cms\Client\Command\ScopeFilterAwareInterface;
use Cms\Client\Command\ScopeFilterAwareTrait;

/**
 * Class FetchAllContractByFilterCommand
 * @package Cms\Client\Command\Contract\Command
 */
class FetchAllContractByFilterCommand implements ScopeFilterAwareInterface
{
    use ScopeFilterAwareTrait;

    /** @var \DateTime */
    protected $beginAt;

    /** @var \DateTime */
    protected $endAt;

    /**
     * FetchAllContractByFilterCommand constructor.
     * @param $scopeId
     */
    public function __construct($scopeId)
    {
        $this->setScopeId($scopeId);
    }

    /**
     * @param \DateTime $beginAt
     * @return $this
     */
    public function setBeginAt(\DateTime $beginAt)
    {
        $this->beginAt = $beginAt;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBeginAt()
    {
        return $this->beginAt;
    }

    /**
     * @param \DateTime $endAt
     * @return $this
     */
    public function setEndAt(\DateTime $endAt)
    {
        $this->endAt = $endAt;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndAt()
    {
        return $this->endAt;
    }
}
