<?php

namespace Cms\Model;

use Move\Utils\Str;

/**
 * Class ConfigModelFactory
 * @package Cms\Model
 */
class ConfigModelFactory
{

    /**
     * @param mixed $value
     * @return \Cms\Model\AbstractConfigModel|null
     */
    public static function createSafeConfig($value)
    {
        try {
            return static::createConfig($value);
        } catch (\Exception $e) {
            trigger_error('Error while decoding config : ' . $e->__toString(), E_USER_WARNING);
        }
        return null;
    }

    /**
     * @param string|mixed $data
     * @return array|mixed
     * @throws \InvalidArgumentException
     * @throws \RuntimeException
     */
    public static function decodeConfigToArray($data)
    {
        // tentative de decodage
        if (\is_string($data)) {
            try {
                $decodedData = Str::parseJson($data);
                if (\is_array($decodedData)) {
                    return $decodedData;
                }
            } catch (\InvalidArgumentException $e) {
            }
            $unserializedData = unserialize($data);
            if (!\is_array($unserializedData)) {
                throw new \RuntimeException('unable to decode data');
            }
            return $unserializedData;
        }
        return $data;
    }

    /**
     * @param AbstractConfigModel|mixed $data
     * @return AbstractConfigModel|null
     * @throws \RuntimeException
     * @throws \InvalidArgumentException
     * @throws \UnexpectedValueException
     */
    public static function createConfig($data)
    {
        // renvoi tel quel si donnée vide ou connu
        if (!$data || $data instanceof AbstractConfigModel) {
            return $data ?: null;
        }

        // tentative de decodage
        if (!\is_array($data)) {
            $data = static::decodeConfigToArray($data);
        }

        // récuperation des donnée et creation du model
        if (\is_array($data) && !empty($data['config_class'])) {
            if (!class_exists($data['config_class'])) {
                throw new \UnexpectedValueException('class ' . $data['config_class'] . ' does not exist');
            }
            $object = new $data['config_class']();
            if ($object instanceof AbstractConfigModel) {
                return $object->populate($data, true);
            }

            throw new \UnexpectedValueException('class ' . $data['config_class']
                . ' must implement AbstractConfigModel');
        }

        return null;
    }
}
