<?php


namespace Cms\Search\Provider\Elastica;

use Cms\Search\ResultElementInterface;
use Elastica\Result;

/**
 * Class ElasticSearchResultElement
 * @package Cms\Search
 */
class ElasticSearchResultElement implements ResultElementInterface
{
    /**
     * @var Result
     */
    private $result;

    /**
     * ElasticSearchResultElement constructor.
     * @param Result $result
     */
    public function __construct(Result $result)
    {
        $this->result = $result;
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->getElasticResult()->getId();
    }

    /**
     * @return array
     */
    public function getSource()
    {
        return $this->getElasticResult()->getSource();
    }

    /**
     * @return Result
     */
    public function getElasticResult()
    {
        return $this->result;
    }

    /**
     * @param string $name
     * @return \Cms\Search\Provider\Elastica\ElasticSearchResultElement[]|null
     */
    public function getInnerHits(string $name)
    {
        $innerHits = $this->getElasticResult()->getInnerHits();
        if (isset($innerHits[$name]['hits']['hits'])
            && \is_array($innerHits[$name]['hits']['hits'])
        ) {
            return array_map(function ($hit) {
                $result = new Result($hit);
                return new self($result);
            }, $innerHits[$name]['hits']['hits']);
        }
        return null;
    }
}
