<?php

namespace Move\Embed\AdapterProvider;

use Move\Embed\Adapter\AdapterInterface;
use Move\Embed\Normalizer\GoogleMapsNormalizer;
use Move\Embed\Parser\MultiRegexParser;
use Move\Embed\Parser\ParserInterface;

/**
 * Class GoogleMaps
 * @package Move\Embed\AdapterProvider
 */
class GoogleMaps extends AbstractAdapterProvider
{

    /** @var string|null */
    private $gmapsApiKey;

    /**
     * GoogleMaps constructor.
     * @param string|null $gmapsApiKey
     */
    public function __construct(string $gmapsApiKey = null)
    {
        $this->gmapsApiKey = $gmapsApiKey;
    }

    /**
     * @return ParserInterface
     */
    public function getParser()
    {
        return new MultiRegexParser([
            '#^(?:https:)?//(?:www\.)?google.(?:fr|com)/maps/d/embed#i',
            '#^(?:https:)?//(?:www\.)?google.(?:fr|com)/maps/place/([^/]+)/@((?:\d*[.])?\d+),((?:\d*[.])?\d+),(\d+)z/.*#i',
        ]);
    }

    /**
     * @return AdapterInterface
     * @internal param array $uriParams
     * @throws \InvalidArgumentException
     * @throws \UnexpectedValueException
     */
    public function getAdapter()
    {
        return new \Move\Embed\Adapter\GoogleMaps(
            new GoogleMapsNormalizer(
                $this->getParser(),
                $this->gmapsApiKey,
                GoogleMapsNormalizer::MODE_IFRAME
            ),
            new GoogleMapsNormalizer(
                $this->getParser(),
                $this->gmapsApiKey,
                GoogleMapsNormalizer::MODE_STATIC
            )
        );
    }
}
