<?php

namespace Move\Http\Client;

use GuzzleHttp\RedirectMiddleware;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use function GuzzleHttp\Psr7\modify_request;

/**
 * Class GuzzleRedirectMiddleware
 * @package Move\Http\Client
 */
class GuzzleRedirectMiddleware extends RedirectMiddleware
{

    /**
     * @inheritdoc
     */
    public function modifyRequest(RequestInterface $request, array $options, ResponseInterface $response)
    {
        $redirRequest = parent::modifyRequest($request, $options, $response);

        if ($request->getHeaderLine('host')) {
            return modify_request($redirRequest, [
                'set_headers' => [
                    'Host' => $request->getHeaderLine('host'),
                ],
            ]);
        }

        return $redirRequest;
    }
}
