<?php

namespace Move\Template\Html\Asset;

/**
 * Class AppleTouchIcon
 * @package Move\Template\Html\Asset
 */
class AppleTouchIcon implements AssetInterface
{

    /** @var string */
    private $iconPath;

    /** @var array */
    private $sizeList;

    /**
     * AppleTouchIcon constructor.
     * @param string $iconPath
     * @param array $sizeList
     */
    public function __construct($iconPath, array $sizeList = [])
    {
        $this->iconPath = $iconPath;
        $this->setSizeList($sizeList);
    }

    /**
     * @param array $sizeList
     * @return $this
     */
    public function setSizeList(array $sizeList = [])
    {
        $this->sizeList = $sizeList ?: [57, 72, 76, 114, 120, 144, 152, 180];
        return $this;
    }

    /**
     * Renvoi la copie sous forme de tableau de la metadata
     * @return array
     */
    public function getArrayCopy()
    {
        return [
            'sizeList' => $this->sizeList,
            'iconPath' => $this->iconPath,
        ];
    }

    /**
     * @return string
     */
    public function render()
    {
        $html = '<link rel="apple-touch-icon" href="'
            . '/apple-touch-icon.png">';
        foreach ($this->sizeList as $size) {
            $html .= '<link rel="apple-touch-icon" href="'
                . $this->iconPath . '/apple-touch-icon-' . $size . '.png" sizes="'
                . $size . 'x' . $size . '">';
        }
        return $html;
    }

    /**
     * Effectue un rendu de l'objet en HTML
     * @return string
     */
    public function __toString()
    {
        return $this->render();
    }
}
