<?php

namespace Move\Http\Route;

use League\Route\Route;
use League\Route\RouteCollection;
use League\Route\RouteGroup;
use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

class LeagueRouteAdapterTest extends TestCase
{

    /**
     * @covers LeagueRouteAdapter::__construct
     * @return LeagueRouteAdapter
     */
    public function testConstruct()
    {
        $instance = new LeagueRouteAdapter(new RouteCollection());
        $route = Reflection::getValue($instance, 'router');
        $this->assertInstanceOf(RouteCollection::class, $route);

        return $instance;
    }

    /**
     * @covers LeagueRouteAdapter::group
     * @depends testConstruct
     * @param LeagueRouteAdapter $routeAdapter
     */
    public function testGroup(LeagueRouteAdapter $routeAdapter)
    {
        $result = $routeAdapter->group('/dummy/prefix', []);
        $this->assertInstanceOf(RouteGroup::class, $result);
    }

    /**
     * @covers LeagueRouteAdapter::map
     * @depends testConstruct
     * @param LeagueRouteAdapter $routeAdapter
     */
    public function testMap(LeagueRouteAdapter $routeAdapter)
    {
        $result = $routeAdapter->map(
            'GET',
            '/dummy/prefix',
            'DummyController::handleRequest'
        );
        $this->assertInstanceOf(Route::class, $result);
    }

}
