<?php

namespace Move\Specification;

use PHPUnit\Framework\TestCase;

/**
 * Class ArraySpecificationTest
 * @package Move\Specification
 */
class ArraySpecificationTest extends TestCase
{

    /**
     * @covers ArraySpecification::__construct
     */
    public function testArraySpecificationConstruct()
    {
        $arraySpec = new ArraySpecification();
        $arraySpec2 = new ArraySpecification();
        $this->assertInstanceOf(
            NotSpecification::class,
            $arraySpec->notSpec()
        );
        $this->assertInstanceOf(
            AndSpecification::class,
            $arraySpec->andSpec($arraySpec2)
        );
        $this->assertInstanceOf(
            OrSpecification::class,
            $arraySpec->orSpec($arraySpec2)
        );
    }

    /**
     * @covers ArraySpecification::isSatisfiedBy
     */
    public function testIsSatisfiedBy()
    {
        $arraySpec = new ArraySpecification();
        $this->assertEquals(
            false,
            $arraySpec->isSatisfiedBy('')
        );
        $this->assertEquals(
            true,
            $arraySpec->isSatisfiedBy([])
        );
    }
}
