<?php


namespace Move\Specification;

use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

/**
 * Class NotSpecificationTest
 * @package Move\Specification
 */
class NotSpecificationTest extends TestCase
{
    /**
     * @covers NotSpecification::__construct
     */
    public function testConstruct() {
        $emptySpec = new EmptySpecification();
        $notEmptySpec = new NotSpecification($emptySpec);

        $this->assertInstanceOf(NotSpecification::class, $notEmptySpec);

        $spec1 = Reflection::getValue($notEmptySpec,'specification');
        $this->assertEquals($emptySpec, $spec1);

        return $notEmptySpec;

    }

    /**
     * @depends testConstruct
     * @covers  NotSpecification::isSatisfiedBy
     * @param NotSpecification $notEmptySpec
     */
    public function testIsSatisfiedBy(NotSpecification $notEmptySpec)
    {
        $this->assertTrue($notEmptySpec->isSatisfiedBy('aa'));
        $this->assertTrue($notEmptySpec->isSatisfiedBy(['t']));
        $this->assertTrue($notEmptySpec->isSatisfiedBy([111]));

        $this->assertFalse($notEmptySpec->isSatisfiedBy([]));
        $this->assertFalse($notEmptySpec->isSatisfiedBy(''));
        $this->assertFalse($notEmptySpec->isSatisfiedBy(0));
    }
}
