<?php

namespace Move\Specification;

use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

/**
 * Class OrSpecificationTest
 * @package Move\Specification
 */
class OrSpecificationTest extends TestCase
{
    /**
     * @var SpecificationInterface
     */
    public $spec1;

    /**
     * @var SpecificationInterface
     */
    public $spec2;

    /**
     * @inheritdoc
     */
    public function setUp()
    {
        $this->spec1 = new ArraySpecification();
        $this->spec2 = new EmptySpecification();
    }

    /**
     * @return array
     */
    public static function provideIsSatisfiedBy()
    {
        // Array or empty
        return [
            ['', true],
            [0, true],
            [[''], true],
            [[], true],
            ['aaa', false],
            [1, false],
        ];
    }

    /**
     * @covers OrSpecification::__construct
     */
    public function testConstruct() {

        $instance = new OrSpecification( $this->spec1,  $this->spec2);

        $this->assertInstanceOf(OrSpecification::class, $instance);

        $spec1 = Reflection::getValue($instance,'specification1');
        $this->assertEquals( $this->spec1, $spec1);

        $spec2 = Reflection::getValue($instance, 'specification2');
        $this->assertEquals( $this->spec2, $spec2);
    }

    /**
     * @covers OrSpecification::isSatisfiedBy
     * @depends testConstruct
     * @dataProvider provideIsSatisfiedBy
     * @param $object
     * @param $expected
     */
    public function testIsSatisfiedBy($object, $expected)
    {
        $instance = new OrSpecification( $this->spec1,  $this->spec2);
        $this->assertEquals($expected, $instance->isSatisfiedBy($object));
    }
}
