<?php


namespace Cms\Client\Article;

use Cms\Client\ClientIndexQueryBuilder;
use Cms\LinkResource\LinkResourceType;
use Cms\Model\Article\ArticleProfil;
use Cms\Model\Article\ArticleState;

/**
 * Class ArticleClientQueryBuilder
 * @package Cms\Client\Article
 */
class ArticleClientQueryBuilder extends ClientIndexQueryBuilder
{
    /**
     * @param \DateTime $sinceDate
     * @return $this
     */
    public function setSinceDate(\DateTime $sinceDate)
    {
        return $this->setFilter('since_date', $sinceDate->getTimestamp());
    }

    /**
     * @param int $marqueId
     * @return $this
     */
    public function setMarqueId($marqueId)
    {
        return $this->setFilter('marque_id', $marqueId);
    }

    /**
     * @param string|LinkResourceType $type
     * @param string $ref
     * @return $this
     */
    public function setLinkResource($type, $ref)
    {
        if (!LinkResourceType::isValid($type)) {
            throw new \InvalidArgumentException('type is invalid : ' . $type);
        }
        return $this->setFilter('resource_type', $type)
            ->setFilter('resource_ref', $ref);
    }

    /**
     * @param int $prodCatId
     * @return $this
     */
    public function setProductCategoryId($prodCatId)
    {
        return $this->setFilter('product_cat_id', $prodCatId);
    }

    /**
     * @param int $scope
     * @return $this
     */
    public function setScope($scope)
    {
        return $this->setFilter('scope', $scope);
    }

    /**
     * @param ArticleProfil|string|array $profil
     * @return $this
     */
    public function setProfils($profil)
    {
        return $this->setFilter('profil', $profil);
    }

    /**
     * @param ArticleState|string|array $state
     * @return $this
     */
    public function setState($state)
    {
        return $this->setFilter('state', $state);
    }

    /**
     * @param bool|int $coverList
     * @return $this
     */
    public function setCoverList($coverList)
    {
        return $this->setFilter('cover_list', $coverList);
    }

    /**
     * @param bool $coverFirst
     * @return $this
     */
    public function hasCoverFirst($coverFirst)
    {
        return $this->setFilter('cover_first', (bool)$coverFirst);
    }

    /**
     * @param bool $coverOnly
     * @return $this
     */
    public function hasCoverOnly($coverOnly)
    {
        return $this->setFilter('cover_only', (bool)$coverOnly);
    }

    /**
     * @param $coverProfil
     * @return $this
     */
    public function hasCoverProfil($coverProfil)
    {
        return $this->setFilter('cover_profil', (bool)$coverProfil);
    }

    /**
     * @param array|int $categoryIds
     * @return $this
     */
    public function setCategories($categoryIds)
    {
        return $this->setFilter('categories', $categoryIds);
    }

    /**
     * @param string|array $tags
     * @return $this
     */
    public function setTags($tags)
    {
        return $this->setFilter('tag', $tags);
    }

    /**
     * @param string $lang
     * @return $this
     */
    public function setLang($lang)
    {
        return $this->setFilter('lang', $lang);
    }

    /**
     * @param $cmsUserId
     * @return mixed
     */
    public function setCmsUserId($cmsUserId)
    {
        return $this->setFilter('cms_user_id', $cmsUserId);
    }
}
