<?php


namespace Cms\Client\Service;

use Cms\Client\Asset\AssetClient;
use Cms\Client\Asset\AssetConfigClient;
use Cms\Client\Asset\AssetTagClient;
use Cms\Client\CmsHttpClientInterface;
use League\Container\ServiceProvider\AbstractServiceProvider;

/**
 * Class AssetProvider
 * @package Cms\Client\Service
 */
class AssetProvider extends AbstractServiceProvider
{

    /** @var array */
    protected $provides = [
        AssetService::class,
        AssetClient::class,
        AssetConfigClient::class,
        AssetTagClient::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        // add clients
        $this->container->add(AssetClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(AssetTagClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(AssetConfigClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add services
        $this->container->add(AssetService::class)
            ->withArguments([
                AssetClient::class,
                AssetTagClient::class,
                AssetConfigClient::class,
            ]);
    }
}
