<?php

namespace Cms\Extension;

use Cms\Route\AssetProxyRoute;
use League\Plates\Engine;
use League\Plates\Extension\ExtensionInterface;
use POM\DomainObjectInterface;

/**
 * Class AssetSrcExtension
 * @package AutoMag\Extension
 */
class AssetSrcExtension implements ExtensionInterface
{

    /** @var AssetProxyRoute */
    private $assetRouter;

    /**
     * AssetSrcExtension constructor.
     * @param AssetProxyRoute $assetRouter
     */
    public function __construct(AssetProxyRoute $assetRouter)
    {
        $this->assetRouter = $assetRouter;
    }

    /**
     * @param Engine $engine
     */
    public function register(Engine $engine)
    {
        $engine->registerFunction('image_src', [$this, 'getImageSrc']);
        $engine->registerFunction('check_image_src', [$this, 'checkImageSrc']);
    }

    /**
     * @param mixed $asset
     * @return bool
     */
    public function checkImageSrc($asset = null) : bool
    {
        if ($asset instanceof DomainObjectInterface) {
            $asset = $asset->getArrayCopy();
        }
        $assetParams = $asset ? (array)$asset : [];
        return !empty($assetParams['asset_id']);
    }

    /**
     * @param mixed $asset
     * @param null|int $width
     * @param null|int $height
     * @return string
     */
    public function getImageSrc($asset = null, $width = null, $height = null) : string
    {
        if ($asset instanceof DomainObjectInterface) {
            $asset = $asset->getArrayCopy();
        }
        $assetParams = $asset ? (array)$asset : [];
        $path = $this->assetRouter->buildWithArray('default', array_merge([
            'width' => $width,
            'height' => $height,
        ], $assetParams));
        return $path;
    }
}
