<?php


namespace Cms\Model\Article\Tag;

use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EnumSpecification;

/**
 * Class TagValidator
 * @package Cms\Model\Article\Tag
 */
class TagValidator extends AbstractDomainObjectStateValidator
{

    /**
     * @return Filter
     */
    protected function createFilter()
    {
        // filtre du model
        $myFilter = new Filter([
            'name' => true,
            'state' => new EnumSpecification(TagState::class),
        ]);
        $myFilter->modify('state', function ($state) {
            return (string)$state;
        });

        return $myFilter;
    }
}
