<?php


namespace Cms\Model\Campsite\Thematic;

use Cms\Specification\SlugSpecification;
use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EnumSpecification;

/**
 * Class ThematicValidator
 * @package Cms\Model\Campsite\Thematic
 */
class ThematicValidator extends AbstractDomainObjectStateValidator
{
    /**
     * @return Filter
     * @throws \InvalidArgumentException
     */
    protected function createFilter() : Filter
    {
        // filtre du model
        $myFilter = new Filter([
            'scope_id' => true,
            'name' => true,
            'slug' => new SlugSpecification(),
            'type' => new EnumSpecification(ThematicType::class),
        ]);
        return $myFilter;
    }
}
