<?php

namespace Move\Cache;

use Psr\Cache\CacheItemPoolInterface;

/**
 * Class CacheAwareTrait
 * @package Move\Cache
 */
trait CacheAwareTrait
{

    /** @var CacheItemPoolInterface */
    protected $pool;

    /**
     * @param CacheItemPoolInterface $pool
     * @return \Psr\Cache\CacheItemPoolInterface
     */
    public function setItemCachePool(CacheItemPoolInterface $pool) : CacheItemPoolInterface
    {
        $this->pool = $pool;
        return $pool;
    }

    /**
     * @return CacheItemPoolInterface|null
     */
    public function getItemCachePool()
    {
        if (!$this->pool instanceof CacheItemPoolInterface) {
            return null;
        }
        return $this->pool;
    }
}
