<?php

namespace Move\Filter;

/**
 * Class FilterAwareTrait
 * @package Move\Filter
 */
trait FilterAwareTrait
{

    /**
     * @var Filter
     */
    private $filter;

    /**
     * @return Filter
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * @param Filter $filter
     * @return $this
     */
    public function setFilter(Filter $filter)
    {
        $this->filter = $filter;

        return $this;
    }

    /**
     * @param array $fromData
     * @param array $injectData
     * @return mixed
     */
    public function processUpdateFilter(array $fromData, array $injectData)
    {
        $datasetToFilter = array_merge($fromData, $injectData);
        return array_intersect_key($this->processFilter($datasetToFilter), $injectData);
    }

    /**
     * @param array $dataset
     * @param string|null $fieldname
     * @return mixed
     */
    public function processFilter(array $dataset, $fieldname = null)
    {
        if (empty($this->filter)) {
            return $dataset;
        }
        return $this->filter->process($dataset, $fieldname);
    }
}
