<?php

namespace Move\Http\Strategy\Handler;

use Move\Http\Strategy\ResponseFactory;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

/**
 * Class JsonpHandlerService
 * @package Move\Http\Strategy\Handler
 */
class JsonpHandlerService extends HandlerServiceAbstract implements HandlerServiceInterface
{

    /** @var  string */
    protected $callbackParam = 'callback';

    /** @var  string */
    protected $callbackFunc;


    /**
     * @inheritdoc
     */
    public function isSatisfiedBy($request) : bool
    {
        if (!$request instanceof ServerRequestInterface) {
            return false;
        }

        // check du callback dans l'url
        $queryParams = $request->getQueryParams();
        if (!empty($queryParams[$this->callbackParam])) {
            $this->callbackFunc = $queryParams[$this->callbackParam];
            return true;
        }

        return false;
    }

    /**
     * @param mixed $dataset
     * @param ResponseInterface $response
     * @return \Psr\Http\Message\MessageInterface|\Psr\Http\Message\ResponseInterface
     * @throws \RuntimeException
     * @throws \InvalidArgumentException
     */
    public function determineResponse($dataset, ResponseInterface $response)
    {
        // récuperation de la reponse
        if (!$dataset instanceof ResponseFactory) {
            $dataset = new ResponseFactory($dataset);
        }
        $response = $dataset->determineResponse($this->getSerializer(), $response);
        $response = $response->withHeader('Content-Type', 'application/javascript');

        // surcharge du body pour le callback function
        $response->getBody()->rewind();
        $bodyContent = $response->getBody()->getContents();
        $bodyContent = $this->callbackFunc . '(' . $bodyContent . ');';
        $response->getBody()->rewind();
        $response->getBody()->write($bodyContent);

        return $response;
    }

    /**
     * @param string $callbackParam
     * @return $this
     */
    public function setCallbackParam($callbackParam)
    {
        $this->callbackParam = $callbackParam;
        return $this;
    }
}
