<?php

namespace Move\Log;

use Gelf\Publisher;
use Gelf\Transport\UdpTransport;
use Monolog\Formatter\GelfMessageFormatter;
use Monolog\Handler\GelfHandler;
use Monolog\Logger;

/**
 * Class LogstashHandlerFactory
 * @package Move\Log
 */
class LogstashHandlerFactory
{

    /**
     * @param string $logstashHost
     * @param int|null $logstashPort
     * @param int|null $logLevel
     * @return \Monolog\Handler\GelfHandler
     */
    public static function createGelfUdp(
        string $logstashHost,
        int $logstashPort = null,
        $logLevel = null
    ) : GelfHandler {
        // udp transport
        $transport = new UdpTransport(
            $logstashHost,
            $logstashPort,
            UdpTransport::CHUNK_SIZE_LAN
        );
        $publisher = new Publisher($transport);

        // create handler
        $gelfHandler = new GelfHandler(
            $publisher,
            $logLevel ?: Logger::WARNING
        );

        // line formater
        $logFormatter = new GelfMessageFormatter();
        $gelfHandler->setFormatter($logFormatter);

        return $gelfHandler;
    }
}
