<?php


namespace Cms\Client\AddressBook;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Model\AddressBook\Address\AddressCategoryModel;

/**
 * Class AddressBookAddressCategoryClient
 * @package Cms\Client\AddressBook
 */
class AddressBookAddressCategoryClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'addressbook/address/category';

    /**
     * @return AddressBookAddressCategoryClientQueryBuilder
     */
    public function getBuilder()
    {
        $builder = new AddressBookAddressCategoryClientQueryBuilder($this);
        return $builder;
    }

    /**
     * @param array $dataset
     * @return AddressCategoryModel
     */
    public function handleData($dataset = [])
    {
        return (new AddressCategoryModel())->populate($dataset ?: [], true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|AddressCategoryModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }
}
