<?php

namespace Cms\Client\Service;

use Cms\Client\CmsHttpClientInterface;
use Cms\Client\CmsScan\CmsScanStatusClient;
use League\Container\ServiceProvider\AbstractServiceProvider;

/**
 * Class CmsScanProvidern
 * @package Cms\Client\Service
 */
class CmsScanProvider extends AbstractServiceProvider
{

    /** @var array */
    protected $provides = [
        CmsScanService::class,
        CmsScanStatusClient::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        // add clients
        $this->container->add(CmsScanStatusClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add services
        $this->container->add(CmsScanService::class)
            ->withArguments([
                CmsScanStatusClient::class,
            ]);
    }
}
