<?php


namespace Cms\Engine;

/**
 * Class EngineDecoratorAwareTrait
 * @package Cms\Engine
 */
trait EngineDecoratorAwareTrait
{

    /** @var  EngineDecorator */
    protected $engineDecorator;

    /**
     * @return EngineDecorator
     * @throws \InvalidArgumentException
     */
    public function getEngineDecorator() : EngineDecorator
    {
        if (!$this->engineDecorator instanceof EngineDecorator) {
            throw new \InvalidArgumentException('Engine decorator is not define');
        }
        return $this->engineDecorator;
    }

    /**
     * @param EngineDecorator $engineDecorator
     * @return $this
     */
    public function setEngineDecorator(EngineDecorator $engineDecorator)
    {
        $this->engineDecorator = $engineDecorator;
        return $this;
    }
}
