<?php

namespace Cms\LinkResource;

/**
 * Class LinkResourceCollection
 * @package Cms\LinkResource
 */
abstract class AbstractLinkResourceCollection implements
    \IteratorAggregate,
    FlattenResourcesAwareInterface
{
    use FlattenResourcesTrait;

    /**
     * LinkResourceCollection constructor.
     * @param array $resources
     * @param bool $convertToTree
     */
    public function __construct($resources, bool $convertToTree = false)
    {
        if ($convertToTree === true) {
            $resourceTree = [];
            foreach ($resources as $resourceModel) {
                $resourceTree[(string)$resourceModel->link_type][] = $resourceModel;
            }
            $resources = $resourceTree;
        }
        if (\is_array($resources)) {
            $this->resources = $resources;
        }
    }

    /**
     * Retrieve an external iterator
     * @link http://php.net/manual/en/iteratoraggregate.getiterator.php
     * @return \Traversable An instance of an object implementing <b>Iterator</b> or
     * @throws \UnexpectedValueException
     * <b>Traversable</b>
     * @since 5.0.0
     */
    public function getIterator()
    {
        return new \ArrayIterator($this->getFlattenResources());
    }
}
