<?php

namespace Cms\Model;

use Move\Utils\ClassDetectorTrait;
use POM\DomainObjectAbstract;

/**
 * Class AbstractConfigModel
 * @package Cms\Model\Asset\Config
 */
abstract class AbstractConfigModel extends DomainObjectAbstract implements \JsonSerializable
{
    use ClassDetectorTrait;

    /** @var  string */
    protected $config_class;

    /**
     * @inheritdoc
     */
    public function jsonSerialize()
    {
        return $this->getArrayCopy();
    }

    /**
     * @param bool $modifiedOnly
     * @return array
     */
    public function getArrayCopy($modifiedOnly = false)
    {
        $array = parent::getArrayCopy($modifiedOnly);
        return array_merge($array, [
            'config_class' => $this->getReflectorClass()->getName(),
        ]);
    }
}
