<?php

namespace Move\Command\Chain;

use Cms\Model\Asset\Attribute\AttributeName;
use Move\Command\Exception\BadParameterException;
use Psr\Http\Message\UploadedFileInterface;

/**
 * Class AbstractUploadedFileHandler
 * @package Cms\Command\Chain
 */
abstract class AbstractUploadedFileHandler extends AbstractHandler
{

    /**
     * @inheritdoc
     * @throws \Move\Command\Exception\BadParameterException
     * @throws \InvalidArgumentException
     * @throws \RuntimeException
     */
    protected function process($uploadedFile)
    {
        if ($uploadedFile instanceof UploadedFileInterface) {
            // check de l'extension du fichier
            $ext = strtolower(pathinfo($uploadedFile->getClientFilename(), PATHINFO_EXTENSION));
            if (empty($ext)) {
                throw new BadParameterException('the file extension is undefined');
            }

            // deplacement du fichier dans un repertoire temporaire
            $tmpFilePath = tempnam('/tmp', 'upload_asset');
            rename($tmpFilePath, $tmpFilePath = $tmpFilePath . '.' . $ext);
            $uploadedFile->moveTo($tmpFilePath);

            // mise a jour des infos avec les données récupérée
            $dataset['attributes'] = [
                AttributeName::ORIGINAL_MD5 => md5_file($tmpFilePath),
            ];
            $dataset['tmp_file'] = $tmpFilePath;
            $dataset['file_ext'] = strtolower($ext);
            $dataset['mime'] = $uploadedFile->getClientMediaType();
            return $dataset;
        }
        return null;
    }
}
