<?php


namespace Move\Http\Client;

/**
 * Class HttpClientAbstract
 * @package Move\Http\Client
 */
abstract class HttpClientAbstract implements HttpClientInterface
{

    /**
     * @param array $segments
     * @param array $queryParams
     * @param array $options
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function get(array $segments, array $queryParams = [], array $options = [])
    {
        $options[HttpRequestOptions::QUERY_PARAMS] = $queryParams;
        return $this->request('GET', $segments, $options);
    }

    /**
     * @param array $segments
     * @param array $options
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function delete(array $segments, array $options = [])
    {
        return $this->request('DELETE', $segments, $options);
    }

    /**
     * @param array $segments
     * @param mixed $bodyContent
     * @param array $options
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function put(array $segments, $bodyContent, array $options = [])
    {
        $options[HttpRequestOptions::BODY_CONTENT] = $bodyContent;
        return $this->request('PUT', $segments, $options);
    }

    /**
     * @param array $segments
     * @param mixed $bodyContent
     * @param array $options
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function post(array $segments, $bodyContent, array $options = [])
    {
        $options[HttpRequestOptions::BODY_CONTENT] = $bodyContent;
        return $this->request('POST', $segments, $options);
    }
}
