<?php

namespace Move\Image\Tools;

/**
 * Class PngCrush
 * @package Move\Image\Tools
 */
class PngCrush
{

    /** @var  string */
    private $binaryPath;

    /**
     * JpegTran constructor.
     * @param string $binaryPath
     */
    public function __construct($binaryPath)
    {
        $this->binaryPath = $binaryPath;
    }

    /**
     * @param string $imagePath
     * @return $this
     * @throws \RuntimeException
     */
    public function optimise($imagePath)
    {
        exec(
            $this->binaryPath . ' -rem gAMA -rem cHRM -rem iCCP -rem sRGB -brute -l 9 -max -reduce -m 0 -q -ow ' . $imagePath,
            $output,
            $resultVar
        );
        if ($resultVar != 0) {
            throw new \RuntimeException('PNGCRUSH was unable to optimise image, result:' . $resultVar . ' File: ' . $imagePath);
        }
        return $this;
    }
}
