<?php

namespace Move\Embed\Normalizer;

use Move\Embed\Parser\RegexParser;
use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

/**
 * Class DailymotionNormalizerTest
 * @package Move\Embed\Normalizer
 */
class DailymotionNormalizerTest extends TestCase
{
    protected $regEx = "#dailymotion\.com/(.*)#";

    /**
     * @return array
     */
    public static function provideNormalizeStr()
    {
        $dmUrl = 'http://www.dailymotion.com/video/';

        // todo Ajouter les autres possibilités
        return [
            ['dailymotion.com/123456', $dmUrl .'123456'],
            ['video123456', $dmUrl .'video123456']
        ];
    }

    /**
     * @covers DailymotionNormalizer::__construct
     */
    public function testConstruct()
    {
        $parser = new RegexParser('/[0-9]+/');
        $instance = new DailymotionNormalizer($parser);

        $this->assertInstanceOf(DailymotionNormalizer::class, $instance);

        $this->assertEquals(
            $parser,
            Reflection::getValue($instance, 'parser')
        );
    }

    /**
     * @dataProvider provideNormalizeStr
     * @depends testConstruct
     * @covers DailymotionNormalizer::normalizeStr
     * @param $str
     * @param $expected
     */
    public function testNormalizeStr($str, $expected)
    {
        $parser = new RegexParser($this->regEx);
        $instance = new DailymotionNormalizer($parser);

        $normalized = $instance->normalizeStr($str);
        $this->assertEquals($expected, $normalized);
    }

    /**
     * @dataProvider provideNormalizeStr
     * @depends testConstruct
     * @covers DailymotionNormalizer::__invoke
     * @param $str
     * @param $expected
     */
    public function testInvoke($str, $expected)
    {
        $parser = new RegexParser($this->regEx);
        $instance = new DailymotionNormalizer($parser);

        $normalized = $instance($str);
        $this->assertEquals($expected, $normalized);
    }
}
