<?php

namespace Move\Http\Route;

use PHPUnit\Framework\TestCase;

class RouteRegistrerTest extends TestCase
{

    /**
     * @covers RouteRegistrer::__construct
     * @return RouteRegistrer
     */
    public function testConstruct()
    {
        /** @var RouterAdapterInterface $routeAdapter */
        $routeAdapter = $this->getMockBuilder(RouterAdapterInterface::class)
            ->getMock();
        $instance = new RouteRegistrer($routeAdapter);

        $this->assertInstanceOf(RouteRegistrer::class, $instance);
        return $instance;
    }

    /**
     * @depends testConstruct
     * @covers RouteRegistrer::getRouter
     * @param RouteRegistrer $instance
     */
    public function testGetRouter(RouteRegistrer $instance)
    {
        $this->assertInstanceOf(
            RouterAdapterInterface::class,
            $instance->getRouter()
        );
    }

    /**
     * @depends testConstruct
     * @covers RouteRegistrer::setRessourcePrefix
     * @param RouteRegistrer $instance
     * @return RouteRegistrer
     */
    public function testSetRessourcePrefix(RouteRegistrer $instance)
    {
        $instance->setRessourcePrefix('/dummy/prefix/');
        return $instance;
    }

    /**
     * @depends testConstruct
     * @covers RouteRegistrer::ressource
     */
    public function testRessource()
    {
        // TODO implemtation unit test
    }

    /**
     * @depends testConstruct
     * @covers RouteRegistrer::controller
     */
    public function testController()
    {
        // TODO implemtation unit test
    }

    /**
     * @depends testConstruct
     * @covers RouteRegistrer::getPatternForId
     * @param RouteRegistrer $instance
     * @return RouteRegistrer
     */
    public function testGetPatternForId(RouteRegistrer $instance)
    {
        $this->assertNotNull($instance->getPatternForId());
        return $instance;
    }

    /**
     * @depends testGetPatternForId
     * @covers RouteRegistrer::setPatternForId
     * @param RouteRegistrer $instance
     */
    public function testSetPatternForId(RouteRegistrer $instance)
    {
        $pattern = ':uuid';
        $instance->setPatternForId($pattern);
        $this->assertEquals(
            $pattern,
            $instance->getPatternForId()
        );
    }
}
