<?php

namespace Cms\Cache;

use Psr\Cache\CacheItemPoolInterface;

/**
 * Class CacheHelper
 * @package Cms\Cache
 */
class CacheHelper
{
    use CacheHelperTrait {
        decorateWithCache as public;
        hitFromCache as public;
        setInCache as public;
    }

    /**
     * CacheHelper constructor.
     * @param \Psr\Cache\CacheItemPoolInterface|null $cacheItemPool
     */
    public function __construct(CacheItemPoolInterface $cacheItemPool = null)
    {
        $this->setItemCachePool(
            $cacheItemPool ?: CacheFactory::createLocalPool()
        );
    }
}
