<?php


namespace Cms\Client\Service;

/**
 * Trait ArticleServiceAwareTrait
 * @package Cms\Client\Service
 */
trait ArticleServiceAwareTrait
{

    /** @var  \Cms\Client\Service\ArticleService */
    protected $articleService;

    /**
     * @param \Cms\Client\Service\ArticleService $articleService
     * @return $this
     */
    public function setArticleService(ArticleService $articleService)
    {
        $this->articleService = $articleService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\ArticleService
     * @throws \DomainException
     */
    public function getArticleService() : ArticleService
    {
        if (!$this->articleService instanceof ArticleService) {
            throw new \DomainException('articleService is not a ArticleService instance');
        }
        return $this->articleService;
    }
}
