<?php


namespace Cms\Extension\MediaHandler;

use Cms\Client\AssetConfigRelationRestfulModel;
use Cms\Model\Asset\AssetProfil;
use League\Plates\Template\Template;

/**
 * Class MediaHandlerImage
 * @package Cms\Extension\MediaHandler
 */
class MediaHandlerImage extends AbstractMediaHandlerComponent
{
    use MediaHandlerSizeTrait;

    /** @var array */
    protected $provides = [
        AssetProfil::IMAGE,
    ];

    /**
     * @param Template $template
     * @param AssetConfigRelationRestfulModel $assetModel
     * @param array $handlerConfig
     */
    protected function assignData(
        Template $template,
        AssetConfigRelationRestfulModel $assetModel,
        array $handlerConfig = []
    ) {
        parent::assignData($template, $assetModel, $handlerConfig);

        // récuperation du format
        $format = null;
        if (!empty($handlerConfig['format'])) {
            $format = $handlerConfig['format'];
        }
        if (($formatData = $this->getFormatSize($format)) !== null) {
            $template->data($formatData);
        }

        // assign des donnée au template
        $template->data([
            'asset' => $assetModel->getArrayCopy(),
        ]);
    }
}
