<?php


namespace Cms\Model\Geodata;

use Cms\Model\GpsLocationPointModelTrait;
use POM\DomainObjectAbstract;
use POM\PredefinedType\GpsLocationPoint;

class PoiModel extends DomainObjectAbstract
{
    use GpsLocationPointModelTrait {
        GpsLocationPointModelTrait::propertySet as gpsOffsetSet;
    }

    protected $id;

    protected $name;

    protected $categories;

    protected $gps_latitude;

    protected $gps_longitude;

    /** @var  \POM\PredefinedType\GpsLocationPoint */
    protected $gps_location;

    protected $address;

    protected $postal_code;

    protected $city;

    protected $insee_code;

    protected $description;

    protected $uri;

    protected $last_update_datatourisme;

    /**
     * @inheritdoc
     */
    public function propertyGet($name)
    {
        if ($name === 'carte_code') {
            $name = 'carte_amenages';
        }

        $result = parent::propertyGet($name);

        if ($result instanceof GpsLocationPoint && (!$result->latitude || !$result->longitude)) {
            return null;
        }

        if (in_array($name, ['name', 'description', 'categories', 'address']) && $result) {
            return json_decode($result, true);
        }

        if ($name === 'last_update_datatourisme') {
            return new \DateTime($result);
        }


        return $result;
    }

    /**
     * @param string $offset
     * @param mixed $value
     */
    public function propertySet($offset, $value)
    {
        if ($offset === "address" && $value === 'null') {
            $value = null;
        }
        if ($offset === 'gps_location') {
            if (is_scalar($value)) {
                $value = trim($value);
            }
            if (\is_array($value) && isset($value['latitude'], $value['longitude'])) {
                $value = (new GpsLocationPoint())->populate([
                    'latitude' => str_replace(',', '.', $value['latitude']),
                    'longitude' => str_replace(',', '.', $value['longitude']),
                ], true);
            }
            if ($value instanceof GpsLocationPoint) {
                parent::propertySet($offset, $value);
            } elseif (!empty($value)) {
                $this->gpsOffsetSet($offset, $value);
            } else {
                parent::propertySet($offset, null);
            }
        } else {
            if ($offset === 'gps_latitude' || $offset === 'gps_longitude') {
                $value = (string)str_replace(',', '.', $value);
            }
            parent::propertySet($offset, $value);
        }
    }
}
