<?php


namespace Cms\Restful;

/**
 * Class TransformerStrategyAwareTrait
 * @package Cms\Restful
 */
trait TransformerStrategyAwareTrait
{

    /** @var  string|TransformStrategy */
    protected $strategy;

    /**
     * @param string|TransformStrategy $strategy
     * @return $this
     * @throws \InvalidArgumentException
     */
    public function setStrategy($strategy)
    {
        if (!TransformStrategy::isValid($strategy)) {
            throw new \InvalidArgumentException('transformer strategy invalid : ' . $strategy);
        }
        $this->strategy = $strategy;
        return $this;
    }
}
