<?php

namespace Move\Template\Extensions;

use League\Plates\Engine;
use League\Plates\Extension\ExtensionInterface;
use Move\Template\Html\Asset\AssetCollection;

/**
 * Class AssetHtml
 * @package Move\Template\Extensions
 */
class AssetHtml implements ExtensionInterface
{
    /**
     * @var AssetCollection
     */
    private $assetCollection;

    /**
     * AssetHtml constructor.
     * @param AssetCollection $assetCollection
     */
    public function __construct(AssetCollection $assetCollection)
    {
        $this->assetCollection = $assetCollection;
    }

    /**
     * @param Engine $engine
     */
    public function register(Engine $engine)
    {
        // gestion d'un precedent
        if ($engine->doesFunctionExist('asset')) {
            $callback = $engine->getFunction('asset')->getCallback();

            /** @var AssetCollection $assetCollection */
            $assetCollection = $callback[0]->getAssetCollection();
            $this->assetCollection = $assetCollection->mergeWith($this->assetCollection, true);

            $engine->dropFunction('asset');
        }
        $engine->registerFunction('asset', [$this, 'renderCollection']);
    }

    /**
     * @param array|string $tags
     * @return string
     */
    public function renderCollection($tags)
    {
        return $this->assetCollection->render($tags);
    }

    /**
     * @return AssetCollection
     */
    public function getAssetCollection()
    {
        return $this->assetCollection;
    }
}
