<?php

namespace Move\Template\Html\Meta;

/**
 * Class Name
 * @package Html\Metadata
 */
class Name implements MetaInterface
{
    /** @var string */
    protected $name;

    /** @var string */
    protected $value;

    /**
     * Meta name/content
     * @param string $name
     * @param string $value
     */
    public function __construct($name, $value)
    {
        $this->name = strtolower($name);
        $this->value = $value;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return $this->render();
    }

    /**
     * Retourne un identifiant
     */
    public function ident()
    {
        return $this->name;
    }

    /**
     * @{@inheritdoc}
     */
    public function render()
    {
        $source = '<meta name="' . $this->name . '" content="' .
            htmlentities($this->value, ENT_COMPAT, 'UTF-8', false) . '">';
        return $source;
    }

    /**
     * Renvoi la copie sous forme de tableau de la metadata
     * @return array
     */
    public function getArrayCopy()
    {
        return [
            'name' => $this->name,
            'value' => $this->value,
        ];
    }
}
