<?php


namespace Move\Embed\Normalizer;

use Move\Embed\Parser\RegexParser;
use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

/**
 * Class DigitekaNormalizerTest
 * @package Move\Embed\Normalizer
 */
class DigitekaNormalizerTest extends TestCase
{
    protected static $mdtk = '123456';

    /**
     * @return array
     */
    public static function provideNormalize()
    {
        return [
            ['/dtk([0-9]+)/', 'dtk111', '/api/search/getvideoinfos/videoid/111/datatype/json/mdtk/'.self::$mdtk],
            ['/dtk([0-9]+)/', 'dtkdtk', 'dtkdtk']
        ];
    }
    /**
     * @covers DigitekaNormalizer::__construct
     */
    public function testConstruct()
    {
        $parser = new RegexParser('/[0-9]+/');
        $instance = new DigitekaNormalizer($parser, self::$mdtk);

        $this->assertInstanceOf(DigitekaNormalizer::class, $instance);

        $this->assertEquals(
            $parser,
            Reflection::getValue($instance, 'parser')
        );
    }

    /**
     * @depends testConstruct
     * @dataProvider provideNormalize
     * @covers DigitekaNormalizer::normalizeStr
     * @param $regex
     * @param $str
     * @param $expected
     */
    public function testNormalizeStr($regex, $str, $expected)
    {
        $parser = new RegexParser($regex);
        $instance = new DigitekaNormalizer($parser, self::$mdtk);
        $this->assertEquals($expected, $instance->normalizeStr($str));
    }

    /**
     * @depends testConstruct
     * @covers DigitekaNormalizer::__invoke
     * @dataProvider provideNormalize
     * @param $regex
     * @param $str
     * @param $expected
     */
    public function testInvoke($regex, $str, $expected)
    {
        $parser = new RegexParser($regex);
        $instance = new DigitekaNormalizer($parser, self::$mdtk);
        $this->assertEquals($expected, $instance($str));
    }

    /**
     * @expectedException \InvalidArgumentException
     * @depends testConstruct
     */
    public function testNormalizeWithException()
    {
        $parser = new RegexParser('/dtk([0-9]+)/');
        $instance = new DigitekaNormalizer($parser, '');
        $instance->normalizeStr('dtk123');
    }
}
