<?php

namespace Cms\Bundle\Member\Exception;

use Cms\Bundle\Member\MemberErrorCode;

/**
 * Class InvalidStateException
 * @package Cms\Bundle\Member\Exception
 */
class InvalidStateException extends RuntimeException
{

    /** @var string */
    private $identifier;

    /**
     * MemberNotFoundException constructor.
     * @param string $identifier
     * @param \Throwable|null $previous
     */
    public function __construct(string $identifier, \Throwable $previous = null)
    {
        $message = 'state invalid for identifier : ' . $identifier;
        parent::__construct($message, MemberErrorCode::INVALID_STATE, $previous);
        $this->identifier = $identifier;
    }

    /**
     * @return string
     */
    public function getIdentifier() : string
    {
        return $this->identifier;
    }
}
