<?php

namespace Cms\Client\Command;

use Move\Command\Exception\NotFoundException;
use Move\Http\Client\Exception\HttpRequestException;

/**
 * Class ControllerExceptionDecorator
 * @package Cms\Client\Command
 */
class ControllerExceptionDecorator implements ExceptionDecoratorInterface
{

    /**
     * Permet d'attraper et de traiter les exceptions envoyé par les CommandHandler
     * On attend que l'exception soit lancée tout simplement, ou qu'une fonction
     * soit renvoyé en contrepartie
     * ```
     * throw $exception
     * ```
     * or
     * ```
     * return function ($request, $response) use ($exception) {
     *      return $response;
     * }
     * ```
     * @param \Move\Command\Exception\NotFoundException $exception
     * @return callable
     * @throws \League\Route\Http\Exception\NotFoundException
     */
    public function getNotFoundDecorator(NotFoundException $exception) : callable
    {
        throw new \League\Route\Http\Exception\NotFoundException(
            $exception->getMessage(),
            $exception
        );
    }

    /**
     * Permet d'attraper et de traiter les exceptions envoyé par les CommandHandler
     * On attend que l'exception soit lancée tout simplement, ou qu'une fonction
     * soit renvoyé en contrepartie
     * ```
     * throw $exception
     * ```
     * or
     * ```
     * return function ($request, $response) use ($exception) {
     *      return $response;
     * }
     * ```
     * @param \Move\Http\Client\Exception\HttpRequestException $exception
     * @return callable
     * @throws \RuntimeException
     */
    public function getHttpRequestDecorator(HttpRequestException $exception) : callable
    {
        throw new \RuntimeException(
            'error while request http server : ' . $exception->getMessage(),
            null,
            $exception
        );
    }

    /**
     * Permet d'attraper et de traiter les exceptions envoyé par les CommandHandler
     * On attend que l'exception soit lancée tout simplement, ou qu'une fonction
     * soit renvoyé en contrepartie
     * ```
     * throw $exception
     * ```
     * or
     * ```
     * return function ($request, $response) use ($exception) {
     *      return $response;
     * }
     * ```
     * @param \Throwable $exception
     * @return callable
     * @throws \RuntimeException
     */
    public function getThrowableDecorator(\Throwable $exception) : callable
    {
        throw new \RuntimeException(
            'an error occured : ' . $exception->getMessage(),
            null,
            $exception
        );
    }
}
