<?php

namespace Cms\Client\Service;

use Cms\Client\Campsite\CampsiteClient;
use Cms\Client\Campsite\CampsiteLogClient;
use Cms\Client\Campsite\CampsitePubClient;
use Cms\Client\Campsite\FeatureClient;
use Cms\Client\Campsite\GroupClient;
use Cms\Client\Campsite\GuideClient;
use Cms\Client\Campsite\ProductClient;
use Cms\Client\Campsite\PubClient;
use Cms\Client\Campsite\ThematicClient;
use Cms\Client\Campsite\Transformer\CampsiteTransformer;
use Cms\Client\Campsite\Transformer\FeatureTransformer;
use Cms\Client\Campsite\Transformer\GroupTransformer;
use Cms\Client\Campsite\Transformer\ProductTransformer;
use Cms\Client\CmsHttpClientInterface;
use Cms\Client\Command\Campsite\CampsiteCommandHandler;
use Cms\Client\Command\Campsite\Command\FetchBulkCampsiteCommand;
use Cms\Client\Command\Campsite\Command\FetchBulkProductCommand;
use Cms\Client\Command\Campsite\Product\ProductCommandHandler;
use Cms\Client\Command\Campsite\Thematic\ThematicCommandHandler;
use Cms\Command\FetchWithScopeCommand;
use League\Container\ServiceProvider\AbstractServiceProvider;
use Move\Command\TacticianBusFactory;

/**
 * Class CampsiteProvider
 * @package Cms\Client\Service
 */
class CampsiteProvider extends AbstractServiceProvider
{

    /** @var array */
    protected $provides = [
        CampsiteService::class,
        CampsiteCommandHandler::class,
        CampsiteClient::class,
        CampsiteLogClient::class,
        GroupClient::class,
        GuideClient::class,
        PubClient::class,
        CampsitePubClient::class,
        FeatureClient::class,
        ProductClient::class,
        ProductCommandHandler::class,
        ThematicClient::class,
        ThematicCommandHandler::class,
        CampsiteTransformer::class,
        GroupTransformer::class,
        FeatureTransformer::class,
        ProductTransformer::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        // add clients
        $this->container->add(CampsiteClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(CampsiteLogClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(GroupClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(FeatureClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(ProductClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(GuideClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(PubClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(CampsitePubClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(ThematicClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add transformer
        $this->container->add(CampsiteTransformer::class);
        $this->container->add(GroupTransformer::class);
        $this->container->add(FeatureTransformer::class);
        $this->container->add(ProductTransformer::class);

        // bus
        $this->container->add(CampsiteCommandHandler::class)
            ->withArguments([CampsiteService::class]);
        $campsiteBus = TacticianBusFactory::mapToClassHandler(
            $this->container,
            [
                FetchWithScopeCommand::class,
                FetchBulkCampsiteCommand::class,
            ],
            CampsiteCommandHandler::class
        );

        $this->container->add(ProductCommandHandler::class)
            ->withArguments([CampsiteService::class]);
        $productBus = TacticianBusFactory::mapToClassHandler(
            $this->container,
            [FetchBulkProductCommand::class],
            ProductCommandHandler::class
        );

        $this->container->add(ThematicCommandHandler::class)
            ->withArguments([CampsiteService::class]);
        $thematicBus = TacticianBusFactory::mapToClassHandler(
            $this->container,
            [FetchWithScopeCommand::class],
            ThematicCommandHandler::class
        );

        // add services
        $this->container->add(CampsiteService::class)
            ->withArguments([
                CampsiteClient::class,
                $campsiteBus,
                CampsiteLogClient::class,
                GroupClient::class,
                FeatureClient::class,
                ProductClient::class,
                $productBus,
                GuideClient::class,
                PubClient::class,
                CampsitePubClient::class,
                ThematicClient::class,
                $thematicBus,
                CampsiteTransformer::class,
                GroupTransformer::class,
                FeatureTransformer::class,
                ProductTransformer::class,
            ]);
    }
}
