<?php

namespace Move\Search\Analyzer;

/**
 * Class GeoFrenchSearchAnalyzer
 * @package Move\Search\Analyzer
 */
class GeoFrenchSearchAnalyzer extends ElasticAnalyzer
{
    /**
     * GeoFrenchSearchAnalyzer constructor.
     * @param string|null $name
     */
    public function __construct(string $name = null)
    {
        parent::__construct($name ?: 'geo_french_search_analyzer', 'standard');
        $this
            ->setFilter('french_elision', PredefinedFilterAnalyzer::FILTER_FRENCH_ELISION)
            ->setFilter('asciifolding')
            ->setFilter('lowercase')
            ->setFilter('french_stop', PredefinedFilterAnalyzer::FILTER_FRENCH_STOP);
    }
}
