<?php

namespace Move\Jato\Mapper;

use GuzzleHttp\Client;
use Move\Http\Client\GuzzleClientAdapter;
use Move\Jato\JatoClient;
use Move\Jato\Model\SelectionFilterName;
use PHPUnit\Framework\TestCase;

/**
 * Class SelectionModelMapperTest
 * @package Move\Jato\Mapper
 */
class SelectionModelMapperTest extends TestCase
{
    /**
     * @return SelectionModelMapper
     */
    public function testConstruct() : SelectionModelMapper
    {
        $email = 'nlegall@movepublishing.com';
        $password = 'king7queen';

        $client = new JatoClient(
            new GuzzleClientAdapter(new Client(), 'webapi-live.jato.com/jato.carspecs.api'), $email,
            $password
        );

        $mapper = new SelectionModelMapper($client);
        $clientTest = $mapper->getClient();

        $this->assertInstanceOf(JatoClient::class, $clientTest, 'Not a JatoClient');
        $this->assertEquals($client, $clientTest, 'Client not equal');

        return $mapper;
    }

    /**
     * @depends testConstruct
     * @param SelectionModelMapper $mapper
     */
    public function testGetClient(SelectionModelMapper $mapper)
    {
        $result = $mapper->getClient();
        $this->assertInstanceOf(JatoClient::class, $result, 'Not a JatoClient');
    }

    /**
     * @depends testConstruct
     * @param SelectionModelMapper $mapper
     */
    public function testGetSelectionFilterList(SelectionModelMapper $mapper)
    {
        $database = 'SSCF_CS2002';
        $makes = ['Aston Martin', 'Audi'];
        $filters = [SelectionFilterName::BODY, SelectionFilterName::DOOR];
        $result = $mapper->getSelectionFilterList($database, $makes, $filters);

        $this->assertNotEmpty($result, 'result empty');
    }

}