<?php


namespace Cms\Client\Command\Article\Command;

use Cms\Client\Command\Article\CategoryFilterAwareInterface;
use Cms\Client\Command\Article\CategoryFilterAwareTrait;
use Cms\Client\Command\ScopeFilterAwareInterface;
use Cms\Client\Command\ScopeFilterAwareTrait;
use Cms\LinkResource\LinkResourceType;
use Cms\Model\Article\ArticleProfil;

/**
 * Class FetchAllArticleByFilterCommand
 * @package AutoMag\Command\Article\Command
 */
class FetchAllArticleByFilterCommand implements
    CategoryFilterAwareInterface,
    ScopeFilterAwareInterface
{
    use CategoryFilterAwareTrait;
    use ScopeFilterAwareTrait;

    /** @var bool */
    private $cover_first = true;

    /** @var bool */
    private $cover_list = false;

    /** @var bool */
    private $cover_profil = false;

    /** @var  \DateTime */
    private $sinceDate;

    /** @var  array */
    private $state;

    /** @var  string */
    private $resource_type;

    /** @var  string */
    private $resource_ref;

    /**
     * @var int
     */
    private $lexiqueWordId;

    /**
     * @var ArticleProfil[]
     */
    private $profils;

    /**
     * @var int
     */
    private $pageNum;

    /**
     * @var array
     */
    private $tags;

    /**
     * @var string
     */
    private $sortByFirstPublished;

    /**
     * @var string
     */
    private $lang;

    /**
     * @var int
     */
    private $cmsUserId;

    /**
     * FetchAllArticleByFilterCommand constructor.
     * @param int $pageNum
     */
    public function __construct($pageNum = 0)
    {
        $this->pageNum = $pageNum;
    }

    /**
     * @return int
     */
    public function getPageNum()
    {
        return $this->pageNum;
    }

    /**
     * @return ArticleProfil[]
     */
    public function getProfils()
    {
        return $this->profils;
    }

    /**
     * @param string|LinkResourceType $type
     * @param string $ref
     * @return $this
     */
    public function setLinkResource($type, $ref)
    {
        if (!LinkResourceType::isValid($type)) {
            throw new \InvalidArgumentException('type is invalid : ' . $type);
        }
        $this->resource_type = $type;
        $this->resource_ref = $ref;
        return $this;
    }

    /**
     * @return string
     */
    public function getLinkResourceType()
    {
        return $this->resource_type;
    }

    /**
     * @return string
     */
    public function getLinkResourceRef()
    {
        return $this->resource_ref;
    }

    /**
     * @param ArticleProfil[] $profils
     * @return FetchAllArticleByFilterCommand
     */
    public function setProfils($profils)
    {
        if (!\is_array($profils)) {
            $profils = [$profils];
        }
        $this->profils = array_merge($this->profils ?: [], $profils);
        return $this;
    }

    /**
     * @return int
     */
    public function getLexiqueWordId()
    {
        return $this->lexiqueWordId;
    }

    /**
     * @param int $lexiqueWordId
     * @return $this
     */
    public function setLexiqueWordId($lexiqueWordId)
    {
        $this->lexiqueWordId = $lexiqueWordId;
        return $this;
    }

    /**
     * @return boolean
     */
    public function getCoverFirst()
    {
        return $this->cover_first;
    }

    /**
     * @param boolean $cover_first
     * @return FetchAllArticleByFilterCommand
     */
    public function hasCoverFirst($cover_first)
    {
        $this->cover_first = $cover_first;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getSinceDate()
    {
        return $this->sinceDate;
    }

    /**
     * @param \DateTime $sinceDate
     * @return FetchAllArticleByFilterCommand
     */
    public function setSinceDate(\DateTime $sinceDate)
    {
        $this->sinceDate = $sinceDate;
        return $this;
    }

    /**
     * @return array
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * @param array $state
     * @return $this
     */
    public function setState($state)
    {
        $this->state = $state;
        return $this;
    }

    /**
     * @return bool|int
     */
    public function getCoverList()
    {
        return $this->cover_list;
    }

    /**
     * @param bool|int $coverList
     * @return $this
     */
    public function setCoverList($coverList)
    {
        $this->cover_list = $coverList;
        return $this;
    }

    /**
     * @return array
     */
    public function getTags()
    {
        return $this->tags;
    }

    /**
     * @param array $tags
     * @return $this
     */
    public function setTags($tags)
    {
        $this->tags = $tags;
        return $this;
    }

    /**
     * @return bool
     */
    public function isSortByFirstPublished()
    {
        return !empty($this->sortByFirstPublished);
    }

    /**
     * @param string $sortByFirstPublished
     * @return $this
     */
    public function setSortByFirstPublished($sortByFirstPublished)
    {
        if ($sortByFirstPublished === true) {
            $sortByFirstPublished = 'desc';
        }
        $this->sortByFirstPublished = $sortByFirstPublished;
        return $this;
    }

    /**
     * @return string
     */
    public function getSortByFirstPublished()
    {
        return $this->sortByFirstPublished;
    }

    /**
     * @param int $pageNum
     * @return $this
     */
    public function setPageNum($pageNum)
    {
        $this->pageNum = $pageNum;
        return $this;
    }

    /**
     * @return bool
     */
    public function isCoverProfil()
    {
        return $this->cover_profil;
    }

    /**
     * @param bool $cover_profil
     */
    public function setCoverProfil($cover_profil)
    {
        $this->cover_profil = $cover_profil;
    }

    /**
     * @return string
     */
    public function getLang()
    {
        return $this->lang;
    }

    /**
     * @param string $lang
     */
    public function setLang($lang)
    {
        $this->lang = $lang;
    }

    /**
     * @return mixed
     */
    public function getCmsUserId()
    {
        return $this->cmsUserId;
    }

    /**
     * @param $cmsUserId
     */
    public function setCmsUserId($cmsUserId)
    {
        $this->cmsUserId = $cmsUserId;
    }
}
