<?php

namespace Cms\Client\Service;

use Cms\Client\Article\ArticleClient;
use Cms\Client\Article\CategoryClient;
use Cms\Client\Article\ContainerClient;
use Cms\Client\Article\LinkResourceClient;
use Cms\Client\Article\Transformer\ArticleTransformer;
use Cms\Client\CmsHttpClientInterface;
use Cms\Client\Command\Article\ArticleCategoryCommandHandler;
use Cms\Client\Command\Article\ArticleCommandHandler;
use Cms\Client\Command\Article\Command\FetchAllArticleByFilterCommand;
use Cms\Client\Command\Article\Command\FetchAllArticleCategoryByFilterCommand;
use Cms\Client\Command\Article\Command\FetchArticleCategoryCommand;
use Cms\Client\Command\Article\Command\FetchArticleCommand;
use League\Container\Argument\RawArgument;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Tactician\Handler\MethodNameInflector\HandleClassNameWithoutSuffixInflector;
use Move\Command\Command\FetchBulkCommand;
use Move\Command\TacticianBusFactory;

/**
 * Class ArticleProvider
 * @package Cms\Client\Service
 */
class ArticleProvider extends AbstractServiceProvider
{

    /** @var array */
    protected $provides = [
        ArticleTransformer::class,
        ArticleClient::class,
        CategoryClient::class,
        ContainerClient::class,
        ArticleService::class,
        ArticleCommandHandler::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        // add clients
        $this->container->add(ArticleClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(CategoryClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(LinkResourceClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(ContainerClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add transformer
        $this->container->add(ArticleTransformer::class)
            ->withArgument(CategoryClient::class);

        // creation du bus de command
        $articleBus = TacticianBusFactory::containerMap($this->container, [
            FetchAllArticleByFilterCommand::class => ArticleCommandHandler::class,
            FetchArticleCommand::class => ArticleCommandHandler::class,
            FetchBulkCommand::class => ArticleCommandHandler::class,
        ], new HandleClassNameWithoutSuffixInflector());

        // ajout des container
        $this->container->add(ArticleCommandHandler::class)
            ->withArguments([
                ArticleService::class,
            ]);

        // creation du bus de command
        $categoryBus = TacticianBusFactory::mapToClassHandler($this->container, [
            FetchArticleCategoryCommand::class,
            FetchAllArticleCategoryByFilterCommand::class,
        ], ArticleCategoryCommandHandler::class);

        // creation des conteneurs
        $this->container->add(ArticleCategoryCommandHandler::class)
            ->withArguments([
                ArticleService::class,
            ]);

        // add services
        $this->container->add(ArticleService::class)
            ->withArguments([
                ArticleClient::class,
                CategoryClient::class,
                ContainerClient::class,
                LinkResourceClient::class,
                ArticleTransformer::class,
                new RawArgument($articleBus),
                new RawArgument($categoryBus),
            ]);
    }
}
