<?php


namespace Cms\Extension\TemplateBloc\Decorator;

use Cms\Decorator\DomainObjectDecoratorInterface;
use Cms\LinkResource\LinkResourceHandler;
use Cms\LinkResource\LinkResourceModel;
use POM\DomainObjectInterface;

/**
 * Class AbstractTemplateBlocDecorator
 * @package Cms\Extension\TemplateBloc\Decorator
 */
abstract class AbstractTemplateBlocDecorator
{

    /** @var LinkResourceHandler */
    protected $resourceHandler;

    /** @var DomainObjectDecoratorInterface[] */
    protected $objectDecorator;

    /**
     * EventTemplateDecorator constructor.
     * @param LinkResourceHandler $resourceHandler
     */
    public function __construct(
        LinkResourceHandler $resourceHandler
    ) {
        $this->resourceHandler = $resourceHandler;
    }

    /**
     * @param DomainObjectDecoratorInterface $objectDecorator
     * @return $this
     */
    public function addObjectDecorator(DomainObjectDecoratorInterface $objectDecorator)
    {
        $this->objectDecorator[] = $objectDecorator;
        return $this;
    }

    /**
     * @param LinkResourceModel $resourceModel
     * @param mixed $command
     * @return mixed
     */
    protected function decorateResourceModel(LinkResourceModel $resourceModel, $command)
    {
        if (empty($this->objectDecorator)) {
            return $command;
        }
        $object = $this->resourceHandler->getDataByModel($resourceModel);
        if (!empty($object) && $object instanceof DomainObjectInterface) {
            foreach ($this->objectDecorator as $decorator) {
                $command = $decorator->decorate($object, $command);
            }
        }
        return $command;
    }
}
