<?php


namespace Move\Embed\Normalizer;

use Move\Embed\Parser\ParserInterface;

/**
 * Class DailymotionNormalizer
 * @package Move\Embed\Normalizer
 */
class DailymotionNormalizer implements NormalizerInterface
{
    /** @var ParserInterface */
    private $parser;

    /**
     * DailymotionNormalizer constructor.
     * @param ParserInterface $parser
     */
    public function __construct(ParserInterface $parser)
    {
        $this->parser = $parser;
    }

    /**
     * @param string $sourceUri
     * @return string
     */
    public function __invoke($sourceUri)
    {
        return 'http://www.dailymotion.com/video/' . $sourceUri;
    }

    /**
     * @inheritdoc
     */
    public function normalizeStr($sourceUri)
    {
        if ($this->parser->matchString($sourceUri, $params) && !empty($params[1])) {
            return 'http://www.dailymotion.com/video/' . $params[1];
        }
        return $sourceUri;
    }
}
