<?php

namespace Move\Iterator;

/**
 * Class MapIterator
 * @package Move\Iterator
 */
class MapIterator extends \IteratorIterator
{

    /** @var callable Callback */
    protected $callback;

    /** @var array */
    protected $arguments;


    /**
     * @param \Traversable $iterator Traversable iterator
     * @param callable $callback Callback used for iterating
     * @param array $arguments
     */
    public function __construct(\Traversable $iterator, callable $callback, array $arguments = [])
    {
        parent::__construct($iterator);

        $this->callback = $callback;
        $this->arguments = $arguments;
    }

    /**
     * @return mixed
     */
    public function current()
    {
        return \call_user_func_array($this->callback, array_merge([parent::current()], $this->arguments));
    }
}
