<?php

namespace Move\Utils;

class Reflection
{
    /**
     * @param $object
     * @param $name
     * @param array $params
     * @return mixed
     * @throws \ReflectionException
     */
    public static function callMethod($object, $name, $params = [])
    {
        $className = \get_class($object);
        $class = new \ReflectionClass($className);
        $method = $class->getMethod($name);
        $method->setAccessible(true);
        return $method->invoke($object, $params);
    }

    /**
     * @param $object
     * @param $property
     * @return mixed
     */
    public static function getValue($object, $property)
    {
        $className = \get_class($object);
        $prop = new \ReflectionProperty($className, $property);
        $prop->setAccessible(true);
        return $prop->getValue($object);
    }
}
