<?php

namespace Move\Http\Strategy\Handler;

use League\Plates\Engine;
use Move\Http\Strategy\ExceptionHandler\ExceptionHandler;
use Move\Http\Strategy\ExceptionHandler\ExceptionHandlerInterface;
use Move\Http\Strategy\ResponseFactory;
use Move\Http\Strategy\Serializer\JsonSerializer;
use Move\Http\Strategy\Serializer\PlatesAdapterSerializer;
use PHPUnit\Framework\TestCase;

/**
 * Class HandlerServiceAbstractTest
 * @package Move\Http\Strategy\Handler
 */
class HandlerServiceAbstractTest extends TestCase
{
    /**
     * @covers HandlerServiceAbstract::__construct
     * @return HandlerServiceAbstract
     */
    public function testConstruct()
    {
        /** @var HandlerServiceAbstract $instance */
        $instance = $this
            ->getMockForAbstractClass(
                HandlerServiceAbstract::class,
                [new JsonSerializer()]
            );

        return $instance;
    }

    /**
     * @depends testConstruct
     * @covers HandlerServiceAbstract::handleException
     * @param HandlerServiceAbstract $instance
     */
    public function testHandleException(HandlerServiceAbstract $instance)
    {
        $result = $instance->handleException(new \Exception('Message'));

        $this->assertInstanceOf(ResponseFactory::class, $result);
    }

    /**
     * @depends testConstruct
     * @covers HandlerServiceAbstract::getSerializer
     * @param HandlerServiceAbstract $instance
     * @return HandlerServiceAbstract
     */
    public function testGetSerializer(HandlerServiceAbstract $instance)
    {
        $serializer = $instance->getSerializer();

        $this->assertInstanceOf(
            JsonSerializer::class,
            $serializer
        );

        return $instance;
    }

    /**
     * @depends testGetSerializer
     * @covers HandlerServiceAbstract::setSerializer
     * @param HandlerServiceAbstract $instance
     * @return HandlerServiceAbstract
     */
    public function testSetSerializer(HandlerServiceAbstract $instance)
    {
        $instance->setSerializer(new PlatesAdapterSerializer(new Engine()));
        $newSerializer = $instance->getSerializer();

        $this->assertInstanceOf(PlatesAdapterSerializer::class, $newSerializer);
        return $instance;
    }

    /**
     * @depends testConstruct
     * @covers HandlerServiceAbstract::getExceptionHandler
     * @param HandlerServiceAbstract $instance
     * @return HandlerServiceAbstract
     */
    public function testGetExceptionHandler(HandlerServiceAbstract $instance)
    {
        $exceptionsHandler = $instance->getExceptionHandler();
        $this->assertInstanceOf(
            ExceptionHandlerInterface::class,
            $exceptionsHandler
        );

        return $instance;
    }

    /**
     * @depends testGetExceptionHandler
     * @covers HandlerServiceAbstract::setExceptionHandler
     * @param HandlerServiceAbstract $instance
     */
    public function testSetExceptionHandler(HandlerServiceAbstract $instance)
    {
        /** @var ExceptionHandler $exceptionHandler */
        $exceptionHandler = $this
            ->getMockBuilder(ExceptionHandler::class)
            ->getMock();

        $instance->setExceptionHandler($exceptionHandler);

        $newExceptionHandler = $instance->getExceptionHandler();

        $this->assertEquals($exceptionHandler, $newExceptionHandler);
    }
}
