<?php

namespace Cms\Client\Article;

use Cms\Client\AbstractClient;
use Cms\Client\Article\Model\ArticleRestfulModel;
use Cms\Client\ClientFetchStrategy;
use Cms\Client\CmsApiIndexIterator;
use Cms\Model\Article\ArticleModel;

/**
 * Class ArticleClient
 * @package Cms\Client\Article
 */
class ArticleClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'article';

    /** @var string */
    protected $fetchStrategy = ClientFetchStrategy::FETCH_ASYNC;

    /**
     * @param array $dataset
     * @return ArticleRestfulModel
     */
    public function handleData($dataset = [])
    {
        return (new ArticleRestfulModel())->populate($dataset, true);
    }

    /**
     * @return ArticleClientQueryBuilder
     */
    public function getBuilder()
    {
        $builder = new ArticleClientQueryBuilder($this);
        return $builder;
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|Model\ArticleRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param null|int $scope
     * @param array $state
     * @param int $page
     * @return Model\ArticleRestfulModel[]|CmsApiIndexIterator
     */
    public function getIndex($scope = null, $state = [], $page = 0)
    {
        $result = $this->getBuilder()
            ->setState($state)
            ->setScope($scope)
            ->getIndex($page);
        return $result;
    }

    /**
     * @param int $scope
     * @return Model\ArticleRestfulModel[]|CmsApiIndexIterator
     */
    public function getCoverIndex($scope)
    {
        return $this->getIndexCover($scope);
    }

    /**
     * @param int $scope
     * @return ArticleRestfulModel[]|CmsApiIndexIterator
     */
    public function getIndexCover($scope)
    {
        $result = $this->getBuilder()
            ->setScope($scope)
            ->hasCoverOnly(true)
            ->getIndex(-1);
        return $result;
    }

    /**
     * @param int|array $categoryIds
     * @param int $page
     * @return ArticleRestfulModel[]|CmsApiIndexIterator
     */
    public function getIndexCoverByCategoriesId($categoryIds, $page = 0)
    {
        $result = $this->getBuilder()
            ->setCategories($categoryIds)
            ->hasCoverOnly(true)
            ->getIndex($page);
        return $result;
    }

    /**
     * @param int|array $categoryIds
     * @param array $state
     * @param int $page
     * @return Model\ArticleRestfulModel[]|CmsApiIndexIterator
     */
    public function getIndexByCategoryIds($categoryIds, $state = [], $page = 0)
    {
        $result = $this->getBuilder()
            ->setCategories($categoryIds)
            ->setState($state)
            ->getIndex($page);
        return $result;
    }

    /**
     * @param string $slug
     * @param int $scope
     * @param string|null $language
     * @return \Cms\Client\Article\Model\ArticleRestfulModel|null
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     */
    public function fetchItemBySlug($slug, $scope, string $language = null)
    {
        $object = $this->fetchItem($slug, [
            'scope' => $scope,
            'language' => $language,
        ]);
        return $object;
    }

    /**
     * @param ArticleModel $object
     * @return ArticleModel|null
     * @throws \LogicException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \InvalidArgumentException
     */
    public function updateItem(ArticleModel $object)
    {
        $object = $this->updateObjectFromClient($object, 'article');
        return $object;
    }

    /**
     * @param ArticleModel $object
     * @return bool|ArticleModel
     * @throws \LogicException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \InvalidArgumentException
     */
    public function createItem(ArticleModel $object)
    {
        $object = $this->createObjectFromClient($object, 'article');
        return $object;
    }
}
